/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.LogoProm;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.hardware.Unknown;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.ProgramException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class LogoProm1
extends LogoProm {
    protected static Dictionary getSystemInfo() {
        Hashtable dict = (Hashtable)((Hashtable)Unknown.getSystemInfoDefault()).clone();
        dict.put("transmissionPossible", Boolean.FALSE);
        return dict;
    }

    public int getID() {
        return 65;
    }

    public int getOrder() {
        return 9991;
    }

    protected Hardware getMaxHardware() throws ProgramException {
        try {
            return (Hardware)Class.forName("DE.siemens.ad.logo.model.hardware.Unknown").newInstance();
        }
        catch (Exception e) {
            throw new ProgramException("LogoProm.getMaxHardware(); No Unknown-class available.");
        }
    }

    public Hardware prepareDownload(DataTransfer dt, WiringDiagram wd) throws ProgramException, ExceptionAlreadyHandledException {
        Hardware hw = super.prepareDownload(dt, wd);
        if (hw.supports("combiModule")) {
            String message = Language.getString("msg.logoProm.wantCardProtection", "Do you want to protect your Program-Module (card)");
            int result = JOptionPane.showConfirmDialog(Application.getInstance().getWindow(), message, null, 0, 3);
            int protection = result == 0 ? 1 : 0;
            try {
                dt.writeByte(0, protection);
            }
            catch (Exception e) {
                throw new ExceptionAlreadyHandledException();
            }
            String msg = protection == 1 ? Language.getString("msg.logoProm.cardProtectionOn", "Card protection on") : Language.getString("msg.logoProm.cardProtectionOff", "Card protection off");
            Log.println(msg);
        }
        return hw;
    }

    static {
        cSystemInfoDict.put("LogoProm1", LogoProm1.getSystemInfo());
    }
}

